;
;***********************
;   DEMO SCAN KEYBOARD *
;     EXPERIMENT 7     *
;***********************

           CPU   "Z80.TBL"
           HOF   "INT8"

           ORG   2000H

COL:       EQU   0B0H
DAT_DSP:   EQU   0B1H
RD_KEY:    EQU   0B2H
P_SCAN:    EQU   0B2H
P_CTRL:    EQU   0B3H
K_PRESS:   EQU   3000H
BASICIO:   EQU   0BBH
LED:       EQU   0BAH


;***********************
;      MAIN PROGRAM    *
;***********************

START:    LD   A,88H
          OUT  (P_CTRL),A
          LD   A,80H
          OUT  (BASICIO),A
          LD   HL,K_PRESS
          LD   (HL),0
          CALL FILL
;
START1:   CALL SCANK          ;get key
          JP   START1
;
;***********************
;        SCAN KEY      *
;***********************
;  O/P = A key code

SCANK:    CALL SCAN           ;Key press
          CP   0FFH
          JR   Z,SCANK        ;not key press goto scank
          CALL KEY_NEW        ;key relese
          JR   C,SCANK        ;no goto scank
          CALL KEY_CODE       ;key code ok
          CALL DSP
          RET

;/* Scan column & in 4 row */

SCAN:     LD   B,4            ;counter 8 column
          LD   C,0FEH          ;start column 0
          LD   HL,DISPY
          LD   (MEMX),HL

SCAN_LP:  CALL SCANC
          IN   A,(RD_KEY)     ;read row for high nibble
          AND  70H
          CP   70H
          JR   NZ,SCAN_L2     ;high nibble not high key is press
;
          RLC  C
          DEC  B
          JP   NZ,SCAN_LP     ;column not equ 8 goto SCAN_LP
;
SCANX:    LD   HL,K_PRESS     ;END column = 8
          RES  0,(HL)         ;Reset flag for key new
          LD   A,0FFH         ;no key press
SCAN_L2:  RET
;
;***********************
;  SCAN KEY & DISPLAY  *
;***********************

SCANC:    PUSH BC
          LD   A,C
          OUT  (P_SCAN),A

          LD   A,0                ;Clear data display
          OUT  (DAT_DSP),A

          LD   HL,(MEMX)          ;find column
          LD   BC,DISPY
          OR   A
          SBC  HL,BC
          LD   A,L
          LD   C,A
          LD   B,0
          LD   HL,DAT1
          ADD  HL,BC

          LD   A,(HL)             ;out column
          OUT  (COL),A

          LD   HL,(MEMX)          ;send data to display
          LD   A,(HL)
          OUT  (DAT_DSP),A
          INC  HL
          LD   (MEMX),HL
          LD   A,80H              ;delay 1 column
SCANC1:   DEC  A
          JR   NZ,SCANC1
          POP  BC
          RET
;
;***********************
; FILL DATA TO DSP BUF *
;***********************

DSP:      LD   C,A
          LD   B,0
          LD   HL,DAT
          ADD  HL,BC
          LD   D,(HL)
          AND  00000011B
          LD   C,A
          LD   B,0
          LD   HL,DISPY
          ADD  HL,BC
          LD   A,(HL)
          XOR  D
          LD   (HL),A
          RET

;***********************
;     DATA OF START    *
;***********************

FILL:     LD   HL,DISPY
          LD   DE,DISPY+1
          LD   BC,3
          LD   (HL),0E0H
          LDIR
          RET

;
;/* Check key release */

KEY_NEW:  LD   HL,K_PRESS     ;address buffer for check key
          BIT  0,(HL)
          SCF                 ;Carry flag set for key not release
          RET  NZ             ;key not relrase exit
          SETT 0,(HL)         ;yes key release
          CCF                 ;Clear flag carry for key code ok
          RET                 ;key ok
;
;/*  Key code */

KEY_CODE:
          LD   B,A
          LD   A,C
          AND  0FH
          OR   B              ;or low(A)&column(C) IS real code
;
          LD   HL,KEYTAB      ;change code for sequency
          LD   B,0            ;sequenc of key board

K_CODE1:  INC  B              ;effect zero flag
          CP   (HL)           ;key code compare key table
          INC  HL
          JR   NZ,K_CODE1
          DEC  B              ;key match
          LD   A,B
          RET
;
;/* table key board */

KEYTAB:
          DFB  6EH,6DH,6BH,67H
          DFB  5EH,5DH,5BH,57H
          DFB  3EH,3DH,3BH,37H

DAT:      DFB  80H,80H,80H,80H
          DFB  40H,40H,40H,40H
          DFB  20H,20H,20H,20H

DAT1:     DFB  20H,10H,8,4


          ORG  3000H
REPDLY:   DFS  1
DISPY:    DFS  4
MEMX:     DFS  1

          END

